
-- base conversion

viewer.mode=FULLSCREEN

function setup()
    showKeyboard()
    rectMode(CENTER)
    b1=button(WIDTH/2-300,HEIGHT-150,"From Base",100)
    b2=button(WIDTH/2+100,HEIGHT-150,"Number",500)
    b3=button(WIDTH/2-300,HEIGHT-300,"To Base",100)
    b4=button(WIDTH/2+100,HEIGHT-300,"Convert",500)
end

function draw()
    background(31, 75, 73, 112)
    b1:draw() 
    b2:draw()  
    b3:draw() 
    b4:draw() 
    text("From base    2-36    use nnn ... (14268)     From base    37+    use n:n:n: ...  (23:34:21:)",WIDTH/2,HEIGHT-200)
    text("Enter values in From Base, Number, and To Base then tap the Convert box",WIDTH/2,HEIGHT-350)
    pushStyle()
    fontSize(30)
    fill(255,0,0)
    text("Convert a number from one base to another",WIDTH/2,HEIGHT-40)
    popStyle()
end

function touched(t)
    showKeyboard()
    if t.state==BEGAN then
        b1.sel=false
        b2.sel=false
        b3.sel=false
        b4.sel=false
        b4.value=""
        b1:touched(t)
        b2:touched(t)
        b3:touched(t)
        b4:touched(t)
    end
end

function keyboard(k)
    b1:keyboard(k)
    b2:keyboard(k)
    b3:keyboard(k)
end

function convert()
    tab={}
    str2="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    if tonumber(b1.value)==nil or tonumber(b1.value)==1 then
        b4.value="Error: From Base invalid"
        return
    end
    if tonumber(b3.value)==nil or tonumber(b3.value)==1 then
        b4.value="Error: To Base invalid"
        return
    end
    if tonumber(b1.value)>36 then
        v=""
        for z=1,#b2.value do
            c=string.sub(b2.value,z,z)
            if c==":" then
                table.insert(tab,tonumber(v))
                v=""
            else
                v=v..c
            end
        end
        if v~="" then
            table.insert(tab,tonumber(v))
        end
        c=0
        for z=1,#tab do
            if tab[z]>=tonumber(b1.value) then
                b4.value="Error: (xx:) in number can't be = to or > than From Base"
                return
            end
            c=c+tab[z]*(b1.value^(#tab-z))
            if c>999999999999999 then
                ba4.value="Error: Number Overflow"
                return
            end

        end
    else
        c=0
        for z=#b2.value,1,-1 do
            s=string.sub(b2.value,z,z)     
            v=string.find(str2,s)-1
            if v>=tonumber(b1.value) then
                b4.value="Error: (xx:) in number can't be = to or > than From Base"
                return 
            end
            c=c+v*b1.value^(#b2.value-z)
            if c>999999999999999 then
                b4.value="Error: Number Overflow"
                return
            end
        end
    end 
    
    str1=""   
    while c>0 do
        i,f=math.modf(c/b3.value)
        r=c%b3.value
        c=i
        if tonumber(b3.value)<37 then
            if r>0 then
                str1=string.sub(str2,r+1,r+1)..str1
            else
                str1="0"..str1
            end
        else
            if r>0 then
                str1=math.tointeger(r)..":"..str1
            else
                str1="0:"..str1
            end
        end
    end
    b4.value=str1
end

button=class()

function button:init(x,y,name,width)
    self.x=x
    self.y=y   
    self.w=width
    self.h=50 
    self.name=name
    self.value=""
    self.sel=false
end

function button:draw()
    fill(255)
    text(self.name,self.x,self.y+50)
    fill(50)
    if self.sel then
        fill(150)
    end
    stroke(255)
    strokeWidth(2)
    rect(self.x,self.y,self.w,self.h)
    fill(255)
    text(self.value,self.x,self.y)
end

function button:touched(t)
    if t.x>self.x-self.w/2 and t.x<self.x+self.w/2 and
            t.y>self.y-self.h/2 and t.y<self.y+self.h/2 then
        self.sel=true
        self.value=""
        if self.name=="Convert" then
            convert()
        end
    end
end

function button:keyboard(k)
    if self.sel then
        self.value=self.value..string.upper(k)
    end
end
